<?php
include "db.php";
header('Content-Type: application/json');

// Get POST data (form parameters, not JSON)
$institute = trim($_POST['institute_name'] ?? '');
$name = trim($_POST['user_name'] ?? '');
$phone = trim($_POST['phone'] ?? '');
$email = trim($_POST['email'] ?? '');
$password = trim($_POST['password'] ?? '');
$api_key = trim($_POST['api_key'] ?? '');
$request_limit = floatval($_POST['request_limit'] ?? 0);
$expiration_time = intval($_POST['expiration_time'] ?? (time() + 86400)); // default 1 day

// Validation
if (!$institute || !$name || !$phone || !$email || !$password || !$api_key) {
    echo json_encode(["success" => false, "error" => "Missing required fields"]);
    exit;
}

// Check for duplicate email
$check = $conn->prepare("SELECT id FROM users WHERE email = ?");
$check->bind_param("s", $email);
$check->execute();
$check->store_result();

if ($check->num_rows > 0) {
    echo json_encode(["success" => false, "error" => "Email already exists"]);
    exit;
}

// Insert new user
$stmt = $conn->prepare("INSERT INTO users (institute_name, user_name, phone, email, password, api_key, request_limit, expiration_time)
                        VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
$stmt->bind_param("ssssssdi", $institute, $name, $phone, $email, $password, $api_key, $request_limit, $expiration_time);

if ($stmt->execute()) {
    echo json_encode([
        "success" => true,
        "message" => "User inserted successfully",
        "user" => [
            "email" => $email,
            "api_key" => $api_key,
            "expires" => date("Y-m-d H:i:s", $expiration_time),
            "request_limit" => number_format($request_limit, 2)
        ]
    ]);
} else {
    echo json_encode(["success" => false, "error" => "Insert failed: " . $stmt->error]);
}

$conn->close();