<?php
session_start();
include "db.php";

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require 'PHPMailer/PHPMailer.php';
require 'PHPMailer/SMTP.php';
require 'PHPMailer/Exception.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $email = trim($_POST['email']);
    $password = $_POST['password'];

    $stmt = $conn->prepare("SELECT * FROM users WHERE email = ?");
    if (!$stmt) {
        header("Location: login.html?error=DB error");
        exit();
    }

    $stmt->bind_param("s", $email);
    $stmt->execute();
    $res = $stmt->get_result();

    if ($res->num_rows === 1) {
        $user = $res->fetch_assoc();

        if (password_verify($password, $user['password'])) {
            // ✅ Session Setup
            $_SESSION['user_email'] = $user['email'];
            $_SESSION['user_name'] = $user['user_name'];
            $_SESSION['api_key'] = $user['api_key'];

            // ✅ Login Alert Email
            $ip_address = $_SERVER['REMOTE_ADDR'];
            $login_time = date("Y-m-d H:i:s");

            $mail = new PHPMailer(true);
            try {
                $mail->isSMTP();
                $mail->Host = 'mail.sm10x.xyz';
                $mail->SMTPAuth = true;
                $mail->Username = 'info@sm10x.xyz';
                $mail->Password = 'info@sm10x.xyz1';
                $mail->SMTPSecure = 'ssl';
                $mail->Port = 465;

                $mail->setFrom('info@sm10x.xyz', 'SM10x Security');
                $mail->addAddress($user['email'], $user['user_name']);
                $mail->Subject = ' Login Alert - SM10x';
                $mail->isHTML(true);

                // Modern UI Email Body
                $mail->Body = "
                <html>
                <body style='margin:0;padding:0;background-color:#121212;font-family:Arial,sans-serif;color:#ffffff;'>
                    <div style='max-width:600px;margin:30px auto;background:#1f1f1f;border-radius:12px;padding:30px;border:1px solid #ffcc00;box-shadow:0 0 20px rgba(255,204,0,0.1);'>
                        <div style='text-align:center;'>
                            <img src='https://sm10x.xyz/assets/logo.png' width='90' alt='SM10x Logo' style='margin-bottom:20px;'>
                            <h2 style='color:#ffcc00;'>🚨 Login Alert</h2>
                            <p style='font-size:16px;'>Hi <b>{$user['user_name']}</b>,</p>
                            <p style='font-size:15px;'>Your account was just accessed.</p>
                            <table style='width:100%;margin-top:20px;font-size:15px;color:#dddddd;'>
                                <tr><td style='padding:8px;'>📍 <strong>IP Address:</strong></td><td>$ip_address</td></tr>
                                <tr><td style='padding:8px;'>⏰ <strong>Login Time:</strong></td><td>$login_time</td></tr>
                            </table>
                            <p style='margin-top:20px;'>If this was you, no action is required.<br>If not, please secure your account now.</p>
                            <a href='https://sm10x.shop/dashboard' style='margin-top:25px;display:inline-block;background:#ffcc00;color:#000;padding:12px 24px;text-decoration:none;border-radius:6px;font-weight:bold;'>Secure Account</a>
                        </div>
                        <hr style='margin:30px 0;border:1px solid #333;'>
                        <p style='text-align:center;font-size:12px;color:#777;'>© 2025 SM10x Security System</p>
                    </div>
                </body>
                </html>
                ";

                $mail->send();
            } catch (Exception $e) {
                error_log("Email Error: " . $mail->ErrorInfo);
            }

            // ✅ Redirect
            header("Location: dashboard.php");
            exit();
        } else {
            header("Location: login.php?error=Invalid password");
            exit();
        }
    } else {
        header("Location: login.php?error=User not found");
        exit();
    }
} else {
    header("Location: login.php?error=Invalid request");
    exit();
}
?>







