<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
// DB config
include "db.php"; // অথবা include_once if needed

require 'PHPMailer/PHPMailer.php';
require 'PHPMailer/SMTP.php';
require 'PHPMailer/Exception.php';
use PHPMailer\PHPMailer\PHPMailer;

header("Content-Type: application/json");

$email = $_GET['email'] ?? '';
$cradit = floatval($_GET['cradit'] ?? 0);
$time = intval($_GET['time'] ?? 0);
$timeType = $_GET['time_type'] ?? 'hour';

if (!$email) exit(json_encode(["success" => false, "message" => "Missing email"]));

$res = $conn->query("SELECT * FROM users WHERE email='$email'");
if ($res->num_rows == 0) exit(json_encode(["success" => false, "message" => "User not found"]));
$user = $res->fetch_assoc();

$new_balance = floatval($user['request_limit']) + $cradit;
$current_expiry = intval($user['expiration_time']);
$new_expiry = time() > $current_expiry ? time() : $current_expiry;
if ($timeType == 'month') $new_expiry += $time * 30 * 24 * 3600;
else $new_expiry += $time * 3600;

// Update user data
$stmt = $conn->prepare("UPDATE users SET request_limit=?, expiration_time=? WHERE email=?");
$stmt->bind_param("dis", $new_balance, $new_expiry, $email);
$stmt->execute();

// Log to credit_logs
$conn->query("INSERT INTO credit_logs (email, added_credit, time_added, time_type, timestamp) VALUES ('$email', '$cradit', '$time', '$timeType', NOW())");

// Send invoice email
$mail = new PHPMailer(true);
try {
    $mail->isSMTP();
    $mail->Host = 'mail.sm10x.xyz';
    $mail->SMTPAuth = true;
    $mail->Username = 'info@sm10x.xyz';
    $mail->Password = 'info@sm10x.xyz1';
    $mail->SMTPSecure = 'ssl';
    $mail->Port = 465;
    $mail->setFrom('info@sm10x.xyz', 'SM10x');
    $mail->addAddress($email);

    $mail->isHTML(true);
    $mail->Subject = '🎉 SM10x Credit Invoice Notification';

    $mail->Body = "
    <div style='background:#1a1a1a;padding:30px;font-family:sans-serif;color:#fff;max-width:600px;margin:auto;border-radius:10px'>
        <h2 style='color:#ffcc00'>🧾 Credit Invoice - SM10x</h2>
        <p>Hi <b>{$user['user_name']}</b>,</p>
        <p>Your voice credits have been successfully updated.</p>

        <div style='background:#222;padding:15px;border-radius:8px;margin-top:20px;margin-bottom:20px'>
            <p><b>🟡 Added Credit:</b> {$cradit}</p>
            <p><b>⏰ Time Added:</b> {$time} {$timeType}(s)</p>
            <p><b>💰 New Balance:</b> {$new_balance}</p>
            <p><b>📅 Expiry:</b> " . date("Y-m-d H:i:s", $new_expiry) . "</p>
        </div>

        <a href='https://panel.sm10x.xyz/' style='display:inline-block;margin-top:10px;padding:10px 20px;background:#ffcc00;color:#000;border-radius:5px;text-decoration:none;font-weight:bold'>🔗 Go to Dashboard</a>
        
        <p style='margin-top:20px;font-size:12px;color:#888'>If you did not perform this, please contact support.</p>
    </div>";

    $mail->send();
} catch (Exception $e) {
    // ignore mail error
}

echo json_encode([
    "success" => true,
    "message" => "Credit updated",
    "new_balance" => $new_balance,
    "expiry" => date("Y-m-d H:i:s", $new_expiry)
]);
?>