<?php
  session_start();
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>SM10X - User Login</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <style>
    body {
      margin: 0;
      padding: 0;
      font-family: 'Segoe UI', sans-serif;
      background: #0e0e0e;
      color: #fff;
      display: flex;
      justify-content: center;
      align-items: center;
      min-height: 100vh;
    }

    .login-box {
      background: #1a1a1a;
      padding: 30px;
      border-radius: 12px;
      box-shadow: 0 0 20px rgba(255, 170, 0, 0.2);
      width: 100%;
      max-width: 350px;
      box-sizing: border-box;
    }

    .login-box h2 {
      margin-bottom: 25px;
      text-align: center;
      color: #ffaa00;
      font-size: 24px;
    }

    .login-box input[type="email"],
    .login-box input[type="password"] {
      width: 100%;
      padding: 12px;
      margin-bottom: 15px;
      border: none;
      border-radius: 8px;
      background: #2b2b2b;
      color: #fff;
      font-size: 16px;
      box-sizing: border-box;
    }

    .login-box .forgot-text {
      text-align: right;
      margin: -10px 0 10px 0;
    }

    .login-box .forgot-text a {
      font-size: 13px;
      color: #ff4d4d;
      text-decoration: none;
      background: transparent;
      font-weight: 500;
      transition: color 0.3s;
    }

    .login-box .forgot-text a:hover {
      color: #ff0000;
    }

    .login-box button {
      width: 100%;
      padding: 12px;
      border: none;
      border-radius: 8px;
      background: #ffaa00;
      color: #000;
      font-weight: bold;
      font-size: 16px;
      cursor: pointer;
      transition: 0.3s;
    }

    .login-box button:hover {
      background: #e69500;
    }

    .error {
      color: #ff4d4d;
      text-align: center;
      margin-bottom: 10px;
      font-size: 14px;
    }

    .success {
      color: #00ff99;
      text-align: center;
      margin-bottom: 10px;
      font-size: 14px;
    }

    @media (max-width: 480px) {
      .login-box {
        padding: 20px;
        margin: 0 15px;
      }

      .login-box h2 {
        font-size: 20px;
      }

      .login-box input, .login-box button {
        font-size: 15px;
      }

      .login-box .forgot-text a {
        font-size: 12px;
      }
    }
  </style>
</head>
<body>
  <form class="login-box" method="POST" action="do_login.php">
    <h2>Login to SM10X</h2>
    <?php
      if (isset($_GET['error'])) {
        echo '<div class="error">' . htmlspecialchars($_GET['error']) . '</div>';
      } elseif (isset($_GET['success'])) {
        echo '<div class="success">' . htmlspecialchars($_GET['success']) . '</div>';
      }
    ?>
    <input type="email" name="email" placeholder="Email address" required>
    <input type="password" name="password" placeholder="Password" required>

    <div class="forgot-text">
      <a href="forgot.html">Forgot Password?</a>
    </div>

    <button type="submit">Login</button>
  </form>
</body>
</html>