<?ph
error_reporting(E_ALL);
ini_set('display_errors', 1);
header("Content-Type: application/json");
include "db.php";
date_default_timezone_set('Asia/Dhaka');
$conn->query("SET time_zone = '+06:00'");
// 1. GET parameters
$api_key = $_GET['api'] ?? '';
$numbers_raw = $_GET['number'] ?? '';
$message = $_GET['message'] ?? '';

// 2. Validation
if (empty($api_key) || empty($numbers_raw) || empty($message)) {
    echo json_encode(["success" => false, "message" => "Missing required parameters."]);
    exit;
}

// 3. Get user by API key
$stmt = $conn->prepare("SELECT * FROM users WHERE api_key = ?");
$stmt->bind_param("s", $api_key);
$stmt->execute();
$user_result = $stmt->get_result();

if ($user_result->num_rows === 0) {
    echo json_encode(["success" => false, "message" => "Invalid API key."]);
    exit;
}

$user = $user_result->fetch_assoc();
$email = $user['email'];

// 4. Check if blocked
if ($user['status'] !== 'active') {
    echo json_encode(["success" => false, "message" => "Account is blocked."]);
    exit;
}

// 5. Check expiry
if (time() > $user['expiration_time']) {
    echo json_encode(["success" => false, "message" => "API access has expired."]);
    exit;
}

// 6. Calculate SMS segment and cost
$segments = ceil(strlen($message) / 160);
$numbers = array_filter(array_map('trim', explode(',', $numbers_raw)));
$total_numbers = count($numbers);
$cost_per_segment = 0.40;
$total_cost = $segments * $total_numbers * $cost_per_segment;

if ($user['request_limit'] < $total_cost) {
    echo json_encode([
        "success" => false,
        "message" => "Insufficient balance.",
        "required" => $total_cost,
        "available_balance" => $user['request_limit']
    ]);
    exit;
}

// 7. Send SMS and log
$sent = 0;
$failures = [];

foreach ($numbers as $number) {
    $number = preg_replace('/[^0-9]/', '', $number);
    if (strlen($number) < 10) continue;

    $api_url = "http://bulksmsbd.net/api/smsapi?api_key=YOUR_BULK_API_KEY&type=text&number=" . urlencode($number) . "&senderid=8809617613571&message=" . urlencode($message);

    $ch = curl_init($api_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($http_code == 200 && $response) {
        $cost = $segments * $cost_per_segment;
        $stmt2 = $conn->prepare("INSERT INTO sms_logs (email, number, message, segments, cost,  sent_at) VALUES (?, ?, ?, ?, ?, Now())");
        $stmt2->bind_param("sssdi", $email, $number, $message, $segments, $cost);
        $stmt2->execute();
        $sent++;
    } else {
        $failures[] = $number;
    }
}

// 8. Update balance
$new_balance = $user['request_limit'] - $total_cost;
$conn->query("UPDATE users SET request_limit = $new_balance WHERE email = '$email'");

// 9. Final response
echo json_encode([
    "success" => true,
    "message" => "SMS sent with results.",
    "sent" => $sent,
    "failed" => $failures,
    "total_numbers" => $total_numbers,
    "segments" => $segments,
    "cost_per_segment" => $cost_per_segment,
    "total_cost" => $total_cost,
    "new_balance" => number_format($new_balance, 2),
    "email" => $email
], JSON_PRETTY_PRINT);
?>